package com.qboxus.tictic.activitesfragments.livestreaming.activities;


import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Dialog;
import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.Window;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.databinding.DataBindingUtil;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.qboxus.tictic.Constants;
import com.qboxus.tictic.R;
import com.qboxus.tictic.activitesfragments.EditTextSheetFragment;
import com.qboxus.tictic.activitesfragments.livestreaming.adapter.LiveCommentsAdapter;
import com.qboxus.tictic.activitesfragments.livestreaming.adapter.LiveUserViewAdapter;
import com.qboxus.tictic.activitesfragments.livestreaming.model.CameraRequestModel;
import com.qboxus.tictic.activitesfragments.livestreaming.model.LiveCoinsModel;
import com.qboxus.tictic.activitesfragments.livestreaming.model.LiveCommentModel;
import com.qboxus.tictic.activitesfragments.livestreaming.model.LiveUserModel;
import com.qboxus.tictic.activitesfragments.livestreaming.stats.LocalStatsData;
import com.qboxus.tictic.activitesfragments.livestreaming.stats.RemoteStatsData;
import com.qboxus.tictic.activitesfragments.livestreaming.stats.StatsData;
import com.qboxus.tictic.activitesfragments.livestreaming.stats.StatsManager;
import com.qboxus.tictic.activitesfragments.livestreaming.ui.VideoGridContainer;
import com.qboxus.tictic.activitesfragments.sendgift.StickerGiftFragment;
import com.qboxus.tictic.activitesfragments.sendgift.StickerModel;
import com.qboxus.tictic.apiclasses.ApiLinks;
import com.qboxus.tictic.databinding.ActivitySingleCastJoinBinding;
import com.qboxus.tictic.interfaces.AdapterClickListener;
import com.qboxus.tictic.interfaces.FragmentCallBack;
import com.qboxus.tictic.models.StreamJoinModel;
import com.qboxus.tictic.models.StreamShowHeartModel;
import com.qboxus.tictic.models.UserModel;
import com.qboxus.tictic.models.UserOnlineModel;
import com.qboxus.tictic.simpleclasses.ApiRepository;
import com.qboxus.tictic.simpleclasses.DataParsing;
import com.qboxus.tictic.simpleclasses.DateOprations;
import com.qboxus.tictic.simpleclasses.Dialogs;
import com.qboxus.tictic.simpleclasses.Functions;
import com.qboxus.tictic.simpleclasses.OnSwipeTouchListener;
import com.qboxus.tictic.simpleclasses.Variables;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.ValueEventListener;
import com.volley.plus.VPackages.VolleyRequest;
import com.volley.plus.interfaces.APICallBack;
import com.volley.plus.interfaces.Callback;

import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;

import io.agora.rtc2.IRtcEngineEventHandler;
import io.agora.rtc2.video.VideoEncoderConfiguration;

public class SingleCastJoinActivity extends RtcBaseActivity implements View.OnClickListener {


    private final long DELAY = 20000;
    public VideoGridContainer mVideoGridContainer;
    public VideoEncoderConfiguration.VideoDimensions mVideoDimension;
    DatabaseReference rootref;
    Context context;
    boolean isLikeStream = true;
    LiveUserModel streamerLiveModel;
    LiveUserViewAdapter liveUserViewAdapter;
    boolean isFirstTimeFlip = true;
    boolean isSendHeart = true;
    String bookingId;
    int userRole = io.agora.rtc2.Constants.CLIENT_ROLE_AUDIENCE;
    LiveUserModel item;
    ActivitySingleCastJoinBinding binding;
    ChildEventListener commentChildListener;
    Calendar current_cal;
    // initailze the adapter
    ArrayList<LiveCommentModel> dataList = new ArrayList<>();
    LiveCommentsAdapter adapter;
    ArrayList<StreamJoinModel> jointUserList = new ArrayList<>();
    ValueEventListener joinValueEventListener;
    ValueEventListener coinValueEventListener;
    ArrayList<LiveCoinsModel> senderCoinsList = new ArrayList<>();
    ArrayList<UserModel> taggedUserList = new ArrayList<>();
    // get the profile details of user
    boolean isRunFirstTime = false;
    boolean isAudioActivated = true, isVideoActivated = true, isbeautyActivated = true;
    MediaPlayer player;
    Handler handler;
    ValueEventListener cameraRequestEventListener;
    boolean isCameraConnect = false;
    ChildEventListener streamerOnlineListener;
    ChildEventListener likeValueEventListener;
    int heartCounter = 0;
    private Timer timer = new Timer();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Functions.setLocale(Functions.getSharedPreference(this).getString(Variables.APP_LANGUAGE_CODE, Variables.DEFAULT_LANGUAGE_CODE)
                , this, getClass(), false);

        binding = DataBindingUtil.setContentView(SingleCastJoinActivity.this,
                R.layout.activity_single_cast_join);

        InitControl();
        ActionControl();
    }

    private void ActionControl() {

        final Animation inAnim = AnimationUtils.loadAnimation(context, R.anim.in_from_right);
        final Animation outAnim = AnimationUtils.loadAnimation(context, R.anim.out_to_left);
        final Animation inPrevAnim = AnimationUtils.loadAnimation(context, R.anim.in_from_left);
        final Animation outPrevAnim = AnimationUtils.loadAnimation(context, R.anim.out_to_right);


        binding.tabMainView.setOnTouchListener(new OnSwipeTouchListener(context) {
            public void onSwipeTop() {

            }

            public void onSwipeRight() {

                binding.viewflliper.setInAnimation(inPrevAnim);
                binding.viewflliper.setOutAnimation(outPrevAnim);
//                binding.innerViewflliper.setInAnimation(inPrevAnim);
//                binding.innerViewflliper.setOutAnimation(outPrevAnim);
//                Log.d(Constants.tag,"start");
//
//                if (binding.viewTwo==binding.viewflliper.getCurrentView())
//                {
//                    if (binding.viewFour==binding.innerViewflliper.getCurrentView())
//                    {
//                        binding.innerViewflliper.showPrevious();
//                    }
//                    else
//                    {
//                        binding.viewflliper.showPrevious();
//                    }
//                }
//                else
//                {
//                    binding.viewflliper.showPrevious();
//                }

            }

            public void onSwipeLeft() {
                binding.viewflliper.setInAnimation(inAnim);
                binding.viewflliper.setOutAnimation(outAnim);
//                binding.innerViewflliper.setInAnimation(inAnim);
//                binding.innerViewflliper.setOutAnimation(outAnim);
                Log.d(Constants.tag, "end");
                if (binding.viewTwo == binding.viewflliper.getCurrentView()) {
//                    if (binding.viewThree==binding.innerViewflliper.getCurrentView())
//                    {
//                        binding.innerViewflliper.showNext();
//                    }

                } else {
                    binding.viewflliper.showNext();
                }


            }

            public void onSwipeBottom() {

            }

            @Override
            public void onDoubleClick(MotionEvent e) {
                if (isSendHeart) {
                    isSendHeart = true;
                    addLikeIntoStream();
                }
            }

            public void onSingleClick() {

            }
        });

        if (isFirstTimeFlip) {
            isFirstTimeFlip = false;
            if (binding.viewOne == binding.viewflliper.getCurrentView()) {
                binding.viewflliper.showNext();
            }
        }

        binding.tabJoinVideo.setOnClickListener(this);
        binding.tabGift.setOnClickListener(this);


    }

    private void addLikeIntoStream() {
        StreamShowHeartModel likeData = new StreamShowHeartModel();
        likeData.setUserId(Functions.getSharedPreference(context).getString(Variables.U_ID, ""));
        likeData.setOtherUserId(item.getUserId());
        rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("LikesStream").push().setValue(likeData).addOnCompleteListener(new OnCompleteListener<Void>() {
            @Override
            public void onComplete(@NonNull Task<Void> task) {
                if (task.isComplete()) {
                    isSendHeart = true;
                }
            }
        });
    }

    private void InitControl() {
        Bundle bundle = getIntent().getExtras();
        if (bundle != null) {
            bookingId = getIntent().getStringExtra("bookingId");
            Bundle bundle1 = getIntent().getBundleExtra("data");
            item = bundle1.getParcelable("dataModel");
        } else {
            finish();
        }

        context = SingleCastJoinActivity.this;
        rootref = FirebaseDatabase.getInstance().getReference();
        binding.tvMessage.setOnClickListener(this);
        binding.tabLikeStreaming.setOnClickListener(this);
        binding.crossBtn.setOnClickListener(this);

        binding.btnfollow.setOnClickListener(this);

        setUpJoinRecycler();
        initCommentAdapter();


        setUpScreenData();
        lounchStreamerCam();
        callApiForGetAllvideos(item.getUserId(), item.getUserName());
    }

    public void ListCommentData() {
        current_cal = Calendar.getInstance();
        if (commentChildListener == null) {
            commentChildListener = new ChildEventListener() {
                @Override
                public void onChildAdded(@NonNull DataSnapshot dataSnapshot, @Nullable String s) {
                    LiveCommentModel model = dataSnapshot.getValue(LiveCommentModel.class);
                    dataList.add(model);

                    if (DateOprations.checkTimeDiffernce(current_cal, model.getCommentTime())) {
                        if (model.getType().equalsIgnoreCase("gift")) {
                            SingleCastJoinActivity.this.runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    ShowGiftAnimation(model);
                                }
                            });
                        }
                    }


                    adapter.notifyDataSetChanged();
                    binding.recylerview.scrollToPosition(dataList.size() - 1);

                }

                @Override
                public void onChildChanged(@NonNull DataSnapshot dataSnapshot, @Nullable String s) {

                }

                @Override
                public void onChildRemoved(@NonNull DataSnapshot dataSnapshot) {
                }

                @Override
                public void onChildMoved(@NonNull DataSnapshot dataSnapshot, @Nullable String s) {

                }

                @Override
                public void onCancelled(@NonNull DatabaseError databaseError) {

                }
            };
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("Chat").addChildEventListener(commentChildListener);
        }
    }

    public void removeCommentListener() {
        if (rootref != null && commentChildListener != null) {
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("Chat").removeEventListener(commentChildListener);
            commentChildListener = null;
        }
    }

    public void removeLikeStream() {
        if (rootref != null && likeValueEventListener != null) {
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("LikesStream").removeEventListener(likeValueEventListener);
            likeValueEventListener = null;
        }


    }

    public void initCommentAdapter() {
        dataList.clear();

        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(context);
        binding.recylerview.setLayoutManager(linearLayoutManager);

        binding.recylerview.setHasFixedSize(true);

        adapter = new LiveCommentsAdapter(context, dataList, new AdapterClickListener() {
            @Override
            public void onItemClick(View view, int pos, Object object) {

            }
        });

        binding.recylerview.setAdapter(adapter);

    }

    private void setUpScreenData() {
        if (item.getIsVerified()==1) {
            binding.ivVerified.setVisibility(View.VISIBLE);
        } else {
            binding.ivVerified.setVisibility(View.GONE);
        }
        binding.tvCoinCount.setText(item.getUserCoins());
        binding.tvMainUserName.setText(item.getUserName());
        binding.ivMainProfile.setController(Functions.frescoImageLoad(item.getUserPicture(), binding.ivMainProfile, false));
        if (item.getUserId().equalsIgnoreCase(Variables.sharedPreferences.getString(Variables.U_ID, ""))) {
            binding.tabGift.setVisibility(View.GONE);
        } else {
            binding.tabGift.setVisibility(View.VISIBLE);
        }
    }

    private void setUpJoinRecycler() {
        GridLayoutManager layoutManager = new GridLayoutManager(context, 2);
        layoutManager.setOrientation(RecyclerView.VERTICAL);
//        binding.liveUserViewRecyclerView.setLayoutManager(layoutManager);
//        liveUserViewAdapter=new LiveUserViewAdapter(context,jointUserList, new AdapterClickListener() {
//            @Override
//            public void onItemClick(View view, int pos, Object object) {
//
//            }
//        });
//        binding.liveUserViewRecyclerView.setAdapter(liveUserViewAdapter);
    }

    private void ListenerJoinNode() {
        if (joinValueEventListener == null) {
            joinValueEventListener = new ValueEventListener() {
                @Override
                public void onDataChange(@NonNull DataSnapshot dataSnapshot) {
                    jointUserList.clear();
                    if (dataSnapshot.exists()) {
                        for (DataSnapshot joinSnapsot : dataSnapshot.getChildren()) {
                            Log.d(Constants.tag, "Data JSON : " + joinSnapsot.getValue().toString());
                            if (!(TextUtils.isEmpty(joinSnapsot.getValue().toString()))) {
                                StreamJoinModel model = joinSnapsot.getValue(StreamJoinModel.class);
                                jointUserList.add(model);
                            }

                        }
                        liveUserViewAdapter.notifyDataSetChanged();
                        binding.liveUserCount.setText(Functions.getSuffix("" + jointUserList.size()));
                    } else {
                        liveUserViewAdapter.notifyDataSetChanged();
                        binding.liveUserCount.setText(Functions.getSuffix("" + jointUserList.size()));
                    }
                }

                @Override
                public void onCancelled(@NonNull DatabaseError databaseError) {
                    liveUserViewAdapter.notifyDataSetChanged();
                    binding.liveUserCount.setText(Functions.getSuffix("" + jointUserList.size()));
                }
            };
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("JoinStream")
                    .addValueEventListener(joinValueEventListener);
        }
    }

//    public void heartsShow()
//    {
//        binding.streamLikeView.addHeart(new Random().nextInt(5));
//    }

    public void removeJoinListener() {
        if (rootref != null && joinValueEventListener != null) {
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("JoinStream").removeEventListener(joinValueEventListener);
            joinValueEventListener = null;
        }
    }

    private void ListenerCoinNode() {
        if (coinValueEventListener == null) {
            coinValueEventListener = new ValueEventListener() {
                @Override
                public void onDataChange(@NonNull DataSnapshot dataSnapshot) {
                    senderCoinsList.clear();
                    if (dataSnapshot.exists()) {
                        for (DataSnapshot joinSnapsot : dataSnapshot.getChildren()) {
                            if (!(TextUtils.isEmpty(joinSnapsot.getValue().toString()))) {
                                LiveCoinsModel model = joinSnapsot.getValue(LiveCoinsModel.class);
                                senderCoinsList.add(model);
                            }
                        }
                        double maxCoins = 0;
                        LiveCoinsModel highCoinSender = null;
                        if (senderCoinsList.size() > 0) {
                            binding.tabCoinSender.setVisibility(View.VISIBLE);
                            maxCoins = Double.valueOf(senderCoinsList.get(0).getSendedCoins());
                            highCoinSender = senderCoinsList.get(0);
                        } else {
                            binding.tabCoinSender.setVisibility(View.GONE);
                        }
                        for (LiveCoinsModel item : senderCoinsList) {
                            if (Double.valueOf(item.getSendedCoins()) > maxCoins) {
                                maxCoins = Double.valueOf(item.getSendedCoins());
                                highCoinSender = item;
                            }
                        }
                        if (highCoinSender != null) {
                            binding.tvSender.setText(highCoinSender.getUserName());
                            binding.ivSender.setController(Functions.frescoImageLoad(highCoinSender.getUserPic(), binding.ivSender, false));
                        }


                    }

                }

                @Override
                public void onCancelled(@NonNull DatabaseError databaseError) {

                }
            };
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("CoinsStream").addValueEventListener(coinValueEventListener);

        }
    }

    public void removeCoinListener() {
        if (rootref != null && coinValueEventListener != null) {
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("CoinsStream").removeEventListener(coinValueEventListener);
            coinValueEventListener = null;
        }
    }

    private void AddJoinNode() {
        StreamJoinModel model = new StreamJoinModel();
        model.setUserId(Functions.getSharedPreference(context).getString(Variables.U_ID, ""));
        model.setUserName(Functions.getSharedPreference(context).getString(Variables.U_NAME, ""));
        model.setUserPic(Functions.getSharedPreference(context).getString(Variables.U_PIC, ""));

        rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("JoinStream")
                .child(Functions.getSharedPreference(context).getString(Variables.U_ID, ""))
                .setValue(model);
    }

    private void startBroadcast() {
        rtcEngine().setClientRole(io.agora.rtc2.Constants.CLIENT_ROLE_BROADCASTER);
        SurfaceView surface = prepareRtcVideo(Integer.parseInt(config().getUid()), true);
        mVideoGridContainer.addUserVideoSurface(Integer.parseInt(config().getUid()), surface, true);
    }

    private void stopBroadcast() {
        rtcEngine().setClientRole(io.agora.rtc2.Constants.CLIENT_ROLE_AUDIENCE);
        removeRtcVideo(Integer.parseInt(config().getUid()), true);
        mVideoGridContainer.removeUserVideo(Integer.parseInt(config().getUid()), true);
    }

    // when user goes to offline then change the value status on firebase
    public void removeJoinNode() {
        if (rootref != null) {
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("JoinStream")
                    .child(Functions.getSharedPreference(context).getString(Variables.U_ID, ""))
                    .removeValue();
        }
    }

    @Override
    public void onClick(View view) {
        switch (view.getId()) {
            case R.id.cross_btn: {
                onBackPressed();
            }
            break;
            case R.id.tabJoinVideo: {
                if (isCameraConnect) {
                    ShowDailogForJoinBroadcast();
                } else {
                    sendCameraRequest();
                }
            }
            break;
            case R.id.tabGift: {
                ShowGiftSheet();
            }
            break;
            case R.id.tvMessage: {
                sendComment();
            }
            break;
            case R.id.tabLikeStreaming: {
                if (isSendHeart) {
                    isSendHeart = true;
                    addLikeIntoStream();
                }
            }
            break;
            case R.id.btnfollow: {
                if (Functions.checkLoginUser(SingleCastJoinActivity.this))
                    followUnFollowUser();
            }
            break;
        }
    }

    private void followUnFollowUser() {
        ApiRepository.callApiForFollowUnFollow(SingleCastJoinActivity.this,
                Functions.getSharedPreference(context).getString(Variables.U_ID, ""),
                item.getUserId(),
                new APICallBack() {
                    @Override
                    public void arrayData(ArrayList arrayList) {
                    }

                    @Override
                    public void onSuccess(String responce) {

                        callApiForGetAllvideos(item.getUserId(), item.getUserName());
                    }

                    @Override
                    public void onFail(String responce) {

                    }

                });

    }

    private void sendComment() {
        EditTextSheetFragment fragment = new EditTextSheetFragment("OwnComment", taggedUserList, new FragmentCallBack() {
            @Override
            public void onResponce(Bundle bundle) {
                if (bundle.getBoolean("isShow", false)) {
                    if (bundle.getString("action").equals("sendComment")) {
                        taggedUserList = (ArrayList<UserModel>) bundle.getSerializable("taggedUserList");
                        String message = bundle.getString("message");
                        binding.tvMessage.setText(message);
                        addMessages("comment");
                    }
                }
            }
        });
        Bundle bundle = new Bundle();
        bundle.putString("replyStr", "");
        fragment.setArguments(bundle);
        fragment.show(getSupportFragmentManager(), "EditTextSheetF");
    }

    private void sendCameraRequest() {
        CameraRequestModel model = new CameraRequestModel();
        model.setRequestState("1");
        rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("CameraRequest")
                .setValue(model).addOnCompleteListener(new OnCompleteListener<Void>() {
                    @Override
                    public void onComplete(@NonNull Task<Void> task) {
                        if (task.isComplete()) {
                            Toast.makeText(context, context.getString(R.string.camera_request_sended), Toast.LENGTH_SHORT).show();
                        }
                    }
                });


    }

    private void showAllUserLikes() {
        if (!(item.getUserId().equalsIgnoreCase(Variables.sharedPreferences.getString(Variables.U_ID, "")))) {
            if (isLikeStream) {
                addLikeComment("like");
                isLikeStream = false;
            }
        }
    }

    private void callApiForGetAllvideos(String userId, String userName) {

        JSONObject parameters = new JSONObject();
        try {

            if (Functions.getSharedPreference(context).getBoolean(Variables.IS_LOGIN, false)) {
                if (userId != null && userName != null) {
                    if (userId.equals(Functions.getSharedPreference(context).getString(Variables.U_ID, ""))) {
                        parameters.put("user_id", userId);
                    } else {
                        parameters.put("user_id", Functions.getSharedPreference(context).getString(Variables.U_ID, ""));
                        parameters.put("other_user_id", userId);
                    }

                } else {
                    parameters.put("user_id", Functions.getSharedPreference(context).getString(Variables.U_ID, ""));
                    parameters.put("username", userName);
                }
            } else {
                if (userId != null && userName != null) {
                    parameters.put("user_id", userId);
                } else {
                    parameters.put("username", userName);
                }
            }

        } catch (Exception e) {
            Log.d(Constants.tag, "Exception: " + e);
        }


        VolleyRequest.JsonPostRequest(SingleCastJoinActivity.this, ApiLinks.showUserDetail, parameters, Functions.getHeaders(this), new Callback() {
            @Override
            public void onResponce(String resp) {
                Functions.checkStatus(SingleCastJoinActivity.this, resp);
                isRunFirstTime = true;
                try {
                    JSONObject jsonObject = new JSONObject(resp);
                    String code = jsonObject.optString("code");
                    if (code.equals("200")) {
                        JSONObject msg = jsonObject.optJSONObject("msg");

                        UserModel userDetailModel = DataParsing.getUserDataModel(msg.optJSONObject("User"));
                        String follow_status = userDetailModel.button.toLowerCase();
                        if (!userDetailModel.id.
                                equals(Functions.getSharedPreference(context).getString(Variables.U_ID, ""))) {

                            if (follow_status.equalsIgnoreCase("following")) {
                                binding.btnfollow.setVisibility(View.GONE);
                            } else if (follow_status.equalsIgnoreCase("friends")) {
                                binding.btnfollow.setVisibility(View.GONE);
                            } else if (follow_status.equalsIgnoreCase("follow back")) {

                                binding.btnfollow.setVisibility(View.VISIBLE);
                                binding.btnfollow.setText(getString(R.string.follow_back));
                            } else {
                                binding.btnfollow.setVisibility(View.VISIBLE);
                                binding.btnfollow.setText(getString(R.string.follow));
                            }


                        }


                    }
                } catch (Exception e) {
                    Log.d(Constants.tag, "Exception: " + e);
                }
            }
        });

    }

    public void ShowDailogForJoinBroadcast() {
        final Dialog alertDialog = new Dialog(context);
        alertDialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        alertDialog.setContentView(R.layout.live_join_broadcast_view);
        alertDialog.getWindow().setBackgroundDrawable(ContextCompat.getDrawable(context, R.drawable.d_round_white_background));

        ImageView swith_camera_btn = alertDialog.findViewById(R.id.swith_camera_btn);
        ImageView live_btn_mute_audio = alertDialog.findViewById(R.id.live_btn_mute_audio);
        ImageView live_btn_beautification = alertDialog.findViewById(R.id.live_btn_beautification);
        ImageView live_btn_mute_video = alertDialog.findViewById(R.id.live_btn_mute_video);
        RelativeLayout tab_cancel = alertDialog.findViewById(R.id.tab_cancel);
        ImageView closeBtn = alertDialog.findViewById(R.id.closeBtn);


        closeBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                alertDialog.dismiss();
            }
        });

        live_btn_mute_audio.setActivated(!isAudioActivated);
        live_btn_mute_video.setActivated(!isVideoActivated);
        live_btn_beautification.setActivated(!isbeautyActivated);

        setBeautyEffectOptions(live_btn_mute_video.isActivated());

        tab_cancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                alertDialog.dismiss();
                onBackPressed();
            }
        });
        swith_camera_btn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                alertDialog.dismiss();
                rtcEngine().switchCamera();
            }
        });
        live_btn_mute_audio.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                alertDialog.dismiss();
                isAudioActivated = live_btn_mute_video.isActivated();
                if (!isAudioActivated) return;
                muteLocalAudioStream(isAudioActivated);
                view.setActivated(!isAudioActivated);
            }
        });
        live_btn_beautification.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                alertDialog.dismiss();
                isbeautyActivated = view.isActivated();
                view.setActivated(!isbeautyActivated);
                setBeautyEffectOptions(isbeautyActivated);
            }
        });
        live_btn_mute_video.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                alertDialog.dismiss();
                isVideoActivated = view.isActivated();
                if (isVideoActivated) {
                    stopBroadcast();
                } else {
                    startBroadcast();
                }
                view.setActivated(!isVideoActivated);
            }
        });
        alertDialog.show();
    }    Runnable runnable = new Runnable() {
        @Override
        public void run() {
            onTuneStop();
        }
    };

    public void ShowGiftSheet() {
        StickerGiftFragment giftFragment = new StickerGiftFragment(item.getUserId(), item.getUserName(), item.getUserPicture(), new FragmentCallBack() {
            @Override
            public void onResponce(Bundle bundle) {
                if (bundle.getBoolean("isShow", false)) {
                    StickerModel model = (StickerModel) bundle.getSerializable("Data");
                    String counter = bundle.getString("count");
                    addGiftComment("gift", counter, model);

                    Log.d(Constants.tag, "Test : " + streamerLiveModel.getUserCoins());
                    if (streamerLiveModel != null) {
                        double userCoins = Double.valueOf(streamerLiveModel.getUserCoins());
                        double userGift = (Long.valueOf(counter) * Double.valueOf(model.coins));
                        userGift = userCoins + userGift;
                        HashMap map = new HashMap();
                        map.put("userCoins", "" + userGift);
                        rootref.child("LiveStreamingUsers").child(item.getStreamingId()).updateChildren(map);
                    }
                } else {
                    if (bundle.getBoolean("showCount", false)) {
                        StickerModel model = (StickerModel) bundle.getSerializable("Data");
                        binding.tvGiftCount.setText(" X " + bundle.getString("count") + " " + model.name);

                        binding.ivGiftCount.setController(Functions.frescoImageLoad(model.image, binding.ivGiftCount, false));

                        binding.tabGiftCount.animate().translationY(binding.animationCapture.getY()).setDuration(700).setListener(new AnimatorListenerAdapter() {
                            @Override
                            public void onAnimationStart(Animator animation) {
                                super.onAnimationStart(animation);
                                binding.tabGiftCount.setAlpha(1);
                            }

                            @Override
                            public void onAnimationEnd(Animator animation) {
                                super.onAnimationEnd(animation);
                                binding.tabGiftCount.clearAnimation();
                                binding.tabGiftCount.animate().alpha(0).translationY(0).setListener(new AnimatorListenerAdapter() {
                                    @Override
                                    public void onAnimationEnd(Animator animation) {
                                        super.onAnimationEnd(animation);
                                        binding.tabGiftCount.clearAnimation();
                                    }
                                }).start();

                            }
                        }).start();

                    }
                }
            }
        });
        giftFragment.show(getSupportFragmentManager(), "");
    }

    public void ShowGiftAnimation(LiveCommentModel item) {


        String[] str = item.getComment().split("=====");

        Uri imageUri = Uri.parse(str[2]);

        binding.ivGiftProfile.setController(Functions.frescoImageLoad(item.getUserPicture(), binding.ivGiftProfile, false));

        binding.ivGiftItem.setController(Functions.frescoImageLoad("" + imageUri, binding.ivGiftItem, false));
        binding.tvGiftTitle.setText(item.getUserName());
        binding.tvGiftCountTitle.setText(getString(R.string.gave_you_a) + " " + str[1]);
        binding.tvSendGiftCount.setText("X " + str[0]);

        binding.tabGiftMain.animate().alpha(1).translationX(binding.animationGiftCapture.getX()).setDuration(3000).setListener(
                new AnimatorListenerAdapter() {
                    @Override
                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        binding.tabGiftMain.animate().translationY(binding.animationCapture.getY()).setDuration(1000).setListener(new AnimatorListenerAdapter() {
                            @Override
                            public void onAnimationEnd(Animator animation) {
                                super.onAnimationEnd(animation);
                                binding.tabGiftMain.clearAnimation();
                                binding.tabGiftMain.animate().alpha(0).translationY(binding.animationResetAnimation.getY()).translationX(binding.animationResetAnimation.getX()).setListener(new AnimatorListenerAdapter() {
                                    @Override
                                    public void onAnimationEnd(Animator animation) {
                                        super.onAnimationEnd(animation);
                                        binding.tabGiftMain.clearAnimation();
                                    }
                                }).start();
                            }
                        }).start();
                    }


                    @Override
                    public void onAnimationStart(Animator animation) {
                        super.onAnimationStart(animation);
                        PlayGiftSound();
                    }
                }).start();
    }

    private void PlayGiftSound() {
        handler = new Handler(Looper.getMainLooper());
        player = MediaPlayer.create(context, R.raw.gift_tone);
        player.setAudioStreamType(AudioManager.STREAM_MUSIC);
        player.setVolume(100, 100);
        player.setOnPreparedListener(new MediaPlayer.OnPreparedListener() {
            @Override
            public void onPrepared(MediaPlayer mp) {
                mp.start();
            }
        });
        handler.postDelayed(runnable, 2000);
    }

    public void onTuneStop() {
        if (player != null && player.isPlaying()) {
            player.stop();
        }
        if (handler != null) {
            handler.removeCallbacks(runnable);
        }
    }

    // send the comment to the live user
    public void addMessages(String type) {


        final String key = rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("Chat").push().getKey();
        String my_id = Functions.getSharedPreference(context).getString(Variables.U_ID, "");
        String my_name = Functions.getSharedPreference(context).getString(Variables.U_NAME, "");
        String my_image = Functions.getSharedPreference(context).getString(Variables.U_PIC, "");

        Date c = Calendar.getInstance().getTime();
        final String formattedDate = Variables.df.format(c);

        LiveCommentModel commentItem = new LiveCommentModel();
        commentItem.setKey(key);
        commentItem.setUserId(my_id);
        commentItem.setUserName(my_name);
        commentItem.setUserPicture(my_image);
        commentItem.setComment(binding.tvMessage.getText().toString());
        commentItem.setType(type);
        commentItem.setCommentTime(formattedDate);

        rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("Chat").child(key).setValue(commentItem);

        binding.tvMessage.setText(context.getString(R.string.add_a_comment));

    }

    // send the comment to the live user
    public void addLikeComment(String type) {

        final String key = rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("Chat").push().getKey();
        String my_id = Functions.getSharedPreference(context).getString(Variables.U_ID, "");
        String my_name = Functions.getSharedPreference(context).getString(Variables.U_NAME, "");
        String my_image = Functions.getSharedPreference(context).getString(Variables.U_PIC, "");

        Date c = Calendar.getInstance().getTime();
        final String formattedDate = Variables.df.format(c);

        LiveCommentModel commentItem = new LiveCommentModel();
        commentItem.setKey(key);
        commentItem.setUserId(my_id);
        commentItem.setUserName(my_name);
        commentItem.setUserPicture(my_image);
        commentItem.setComment(my_name + " " + getString(R.string.like_this_stream));
        commentItem.setType(type);
        commentItem.setCommentTime(formattedDate);
        rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("Chat").child(key).setValue(commentItem);

        binding.tvMessage.setText(context.getString(R.string.add_a_comment));

    }

    // send the comment to the live user
    public void addGiftComment(String type, String count, StickerModel model) {

        final String key = rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("Chat").push().getKey();
        String my_id = Functions.getSharedPreference(context).getString(Variables.U_ID, "");
        String my_name = Functions.getSharedPreference(context).getString(Variables.U_NAME, "");
        String my_image = Functions.getSharedPreference(context).getString(Variables.U_PIC, "");

        Date c = Calendar.getInstance().getTime();
        final String formattedDate = Variables.df.format(c);

        LiveCommentModel commentItem = new LiveCommentModel();
        commentItem.setKey(key);
        commentItem.setUserId(my_id);
        commentItem.setUserName(my_name);
        commentItem.setUserPicture(my_image);
        commentItem.setComment(count + "=====" + model.name + "=====" + model.image);
        commentItem.setType(type);
        commentItem.setCommentTime(formattedDate);
        commentItem.setSound(model.sound);
        rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("Chat").child(key).setValue(commentItem);
        LiveCoinsModel coinsModel = new LiveCoinsModel();
        coinsModel.setUserId(my_id);
        coinsModel.setUserName(my_name);
        coinsModel.setUserPic(my_image);
        coinsModel.setSendedCoins("" + (Double.valueOf(count) * Double.valueOf(model.coins)));
        rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("CoinsStream").child(my_id).addListenerForSingleValueEvent(new ValueEventListener() {
            @Override
            public void onDataChange(@NonNull DataSnapshot snapshot) {
                if (snapshot.exists()) {
                    LiveCoinsModel preModel = snapshot.getValue(LiveCoinsModel.class);
                    double totalCoins = Double.valueOf(preModel.getSendedCoins());
                    totalCoins = totalCoins + ((Double.valueOf(count) * Double.valueOf(model.coins)));

                    HashMap<String, Object> updateMap = new HashMap<>();
                    updateMap.put("sendedCoins", "" + totalCoins);

                    rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("CoinsStream").child(my_id).updateChildren(updateMap);
                } else {
                    rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("CoinsStream").child(my_id).setValue(coinsModel);
                }
            }

            @Override
            public void onCancelled(@NonNull DatabaseError error) {

            }
        });

        binding.tvMessage.setText(context.getString(R.string.add_a_comment));

    }

    private void lounchStreamerCam() {
        joinStream();
        AddJoinNode();
        ListenerCoinNode();
        ListenerJoinNode();
        ListCommentData();
        addLikeStream();
        addNodeCameraRequest();
        addStreamerOnlineStatus();

    }

    private void addNodeCameraRequest() {
        if (cameraRequestEventListener == null) {

            cameraRequestEventListener = new ValueEventListener() {
                @Override
                public void onDataChange(@NonNull DataSnapshot snapshot) {
                    if (snapshot.exists()) {
                        CameraRequestModel model = snapshot.getValue(CameraRequestModel.class);
                        if (model.getRequestState().equals("2")) {
                            Toast.makeText(context, context.getString(R.string.camera_request_granted), Toast.LENGTH_SHORT).show();
//                            tabJoinVideo.setImageDrawable(ContextCompat.getDrawable(context,R.drawable.ic_duet_post_new));
                            isCameraConnect = true;
                        } else if (model.getRequestState().equals("1")) {
//                            tabJoinVideo.setImageDrawable(ContextCompat.getDrawable(context,R.drawable.ic_non_duet_post_new));
                            isCameraConnect = false;
                        } else {
//                            tabJoinVideo.setImageDrawable(ContextCompat.getDrawable(context,R.drawable.ic_non_duet_post_new));
                            isCameraConnect = false;
                            Toast.makeText(context, context.getString(R.string.camera_request_rejected), Toast.LENGTH_SHORT).show();
                        }
                    }
                }

                @Override
                public void onCancelled(@NonNull DatabaseError error) {
                    isCameraConnect = false;
                }
            };
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("CameraRequest").addValueEventListener(cameraRequestEventListener);

        }
    }

    private void removeNodeCameraRequest() {
        if (rootref != null && cameraRequestEventListener != null) {
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("CameraRequest").removeEventListener(cameraRequestEventListener);
            cameraRequestEventListener = null;
        }
    }

    private void addStreamerOnlineStatus() {
        if (streamerOnlineListener == null) {
            streamerOnlineListener = new ChildEventListener() {
                @Override
                public void onChildAdded(@NonNull DataSnapshot snapshot, @Nullable String previousChildName) {
                    if (!(TextUtils.isEmpty(snapshot.getValue().toString()))) {
                        UserOnlineModel itemUpdate = snapshot.getValue(UserOnlineModel.class);
                        if (item.getUserId().equalsIgnoreCase(itemUpdate.getUserId())) {
                            if (timer != null) {
                                Dialogs.cancelIndeterminentLoader();
                                timer.cancel();
                            }
                        }

                    }
                }

                @Override
                public void onChildChanged(@NonNull DataSnapshot snapshot, @Nullable String previousChildName) {

                }

                @Override
                public void onChildRemoved(@NonNull DataSnapshot snapshot) {
                    if (!(TextUtils.isEmpty(snapshot.getValue().toString()))) {
                        SingleCastJoinActivity.this.runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                UserOnlineModel itemUpdate = snapshot.getValue(UserOnlineModel.class);
                                if (item.getUserId().equalsIgnoreCase(itemUpdate.getUserId())) {
                                    Dialogs.showIndeterminentLoader(SingleCastJoinActivity.this, itemUpdate.getUserName() + " " + context.getString(R.string.single_is_week)
                                            , false, false);
                                    timer.cancel();
                                    timer = new Timer();
                                    timer.schedule(
                                            new TimerTask() {
                                                @Override
                                                public void run() {
                                                    SingleCastJoinActivity.this.runOnUiThread(new Runnable() {
                                                        @Override
                                                        public void run() {
                                                            Dialogs.cancelIndeterminentLoader();
                                                            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).removeValue();
                                                        }
                                                    });
                                                }
                                            },
                                            DELAY
                                    );
                                }

                            }
                        });

                    }
                }

                @Override
                public void onChildMoved(@NonNull DataSnapshot snapshot, @Nullable String previousChildName) {

                }

                @Override
                public void onCancelled(@NonNull DatabaseError error) {

                }
            };
            rootref.child(Variables.onlineUser).addChildEventListener(streamerOnlineListener);

        }
    }

    private void removeStreamerOnlineStatus() {
        if (rootref != null && streamerOnlineListener != null) {
            rootref.child(Variables.onlineUser).removeEventListener(streamerOnlineListener);
            streamerOnlineListener = null;
        }
    }

    private void addLikeStream() {
        if (likeValueEventListener == null) {
            likeValueEventListener = new ChildEventListener() {
                @Override
                public void onChildAdded(@NonNull DataSnapshot snapshot, @Nullable String previousChildName) {
                    if (snapshot.exists()) {
                        StreamShowHeartModel likeData = snapshot.getValue(StreamShowHeartModel.class);
                        SingleCastJoinActivity.this.runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                heartCounter = heartCounter + 1;
//                                binding.tvOtherUserLikes.setText(Functions.getSuffix(""+heartCounter)+" "+context.getString(R.string.likes));
                                //   heartsShow();
                            }
                        });
                    }
                }

                @Override
                public void onChildChanged(@NonNull DataSnapshot snapshot, @Nullable String previousChildName) {

                }

                @Override
                public void onChildRemoved(@NonNull DataSnapshot snapshot) {

                }

                @Override
                public void onChildMoved(@NonNull DataSnapshot snapshot, @Nullable String previousChildName) {

                }

                @Override
                public void onCancelled(@NonNull DatabaseError error) {

                }
            };
            rootref.child("LiveStreamingUsers").child(item.getStreamingId()).child("LikesStream").addChildEventListener(likeValueEventListener);

        }
    }

    private void joinStream() {
        boolean isBroadcaster = false;
        isAudioActivated = !isBroadcaster;
        isVideoActivated = !isBroadcaster;
        isbeautyActivated = false;
        setBeautyEffectOptions(isbeautyActivated);
        mVideoGridContainer = findViewById(R.id.live_video_grid_layout);
        mVideoGridContainer.setStatsManager(setStatsManager());
        setClientRole(userRole);
        if (isBroadcaster)
            startBroadcast();
        mVideoDimension = getconfigDimenIndex();
    }

    private void removeNodeListener() {
        removeJoinNode();
        removeCoinListener();
        removeJoinListener();
        removeCommentListener();
        removeLikeStream();
        removeNodeCameraRequest();
        removeStreamerOnlineStatus();
    }

    @Override
    public void onJoinChannelSuccess(String channel, int uid, int elapsed) {
        // Do nothing at the moment
    }

    @Override
    public void onUserJoined(int uid, int elapsed) {
        // Do nothing at the moment
    }

    @Override
    public void onUserOffline(final int uid, int reason) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                removeRemoteUser(uid);
                if (rootref != null && item != null) {
                    rootref.child("LiveStreamingUsers").child(item.getStreamingId()).removeValue();
                }
                finish();
            }
        });
    }

    @Override
    public void onFirstRemoteVideoDecoded(final int uid, int width, int height, int elapsed) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Functions.printLog(Constants.tag, "onFirstRemoteVideoDecoded");
                renderRemoteUser(uid);
            }
        });
    }

    private void renderRemoteUser(int uid) {
        Functions.printLog(Constants.tag, "renderRemoteUser");
        SurfaceView surface = prepareRtcVideo(uid, false);
        mVideoGridContainer.addUserVideoSurface(uid, surface, false);
    }

    private void removeRemoteUser(int uid) {
        removeRtcVideo(uid, false);
        mVideoGridContainer.removeUserVideo(uid, false);
    }

    @Override
    public void onLocalVideoStats(IRtcEngineEventHandler.LocalVideoStats stats) {
        if (!statsManager().isEnabled()) return;

        LocalStatsData data = (LocalStatsData) statsManager().getStatsData(Integer.parseInt(config().getUid()));
        if (data == null) return;

        data.setWidth(mVideoDimension.width);
        data.setHeight(mVideoDimension.height);
        data.setFramerate(stats.sentFrameRate);
    }

    @Override
    public void onRtcStats(IRtcEngineEventHandler.RtcStats stats) {
        if (!statsManager().isEnabled()) return;

        LocalStatsData data = (LocalStatsData) statsManager().getStatsData(Integer.parseInt(config().getUid()));
        if (data == null) return;

        data.setLastMileDelay(stats.lastmileDelay);
        data.setVideoSendBitrate(stats.txVideoKBitRate);
        data.setVideoRecvBitrate(stats.rxVideoKBitRate);
        data.setAudioSendBitrate(stats.txAudioKBitRate);
        data.setAudioRecvBitrate(stats.rxAudioKBitRate);
        data.setCpuApp(stats.cpuAppUsage);
        data.setCpuTotal(stats.cpuAppUsage);
        data.setSendLoss(stats.txPacketLossRate);
        data.setRecvLoss(stats.rxPacketLossRate);
    }

    // check the network quality
    @Override
    public void onNetworkQuality(int uid, int txQuality, int rxQuality) {
        if (!statsManager().isEnabled()) return;

        StatsData data = statsManager().getStatsData(uid);
        if (data == null) return;

        data.setSendQuality(statsManager().qualityToString(txQuality));
        data.setRecvQuality(statsManager().qualityToString(rxQuality));
    }

    @Override
    public void onRemoteVideoStats(IRtcEngineEventHandler.RemoteVideoStats stats) {
        if (!statsManager().isEnabled()) return;

        RemoteStatsData data = (RemoteStatsData) statsManager().getStatsData(stats.uid);
        if (data == null) return;

        data.setWidth(stats.width);
        data.setHeight(stats.height);
        data.setFramerate(stats.rendererOutputFrameRate);
        data.setVideoDelay(stats.delay);
    }

    @Override
    public void onRemoteAudioStats(IRtcEngineEventHandler.RemoteAudioStats stats) {
        if (!statsManager().isEnabled()) return;

        RemoteStatsData data = (RemoteStatsData) statsManager().getStatsData(stats.uid);
        if (data == null) return;

        data.setAudioNetDelay(stats.networkTransportDelay);
        data.setAudioNetJitter(stats.jitterBufferDelay);
        data.setAudioLoss(stats.audioLossRate);
        data.setAudioQuality(statsManager().qualityToString(stats.quality));
    }

    public void muteLocalAudioStream(boolean isAudioActivated) {
        rtcEngine().muteLocalAudioStream(isAudioActivated);
    }

    public void setBeautyEffectOptions(boolean isbeautyActivated) {
        rtcEngine().setBeautyEffectOptions(isbeautyActivated,
                com.qboxus.tictic.activitesfragments.livestreaming.Constants.DEFAULT_BEAUTY_OPTIONS);
    }

    public VideoEncoderConfiguration.VideoDimensions getconfigDimenIndex() {
        return com.qboxus.tictic.activitesfragments.livestreaming.Constants.VIDEO_DIMENSIONS[
                config().getVideoDimenIndex()];
    }

    public StatsManager setStatsManager() {
        return statsManager();
    }

    public void setClientRole(int userRole) {
        rtcEngine().setClientRole(userRole);
    }

    @Override
    public void onBackPressed() {
        removeNodeListener();
        finish();
    }

    @Override
    protected void onDestroy() {
        statsManager().clearAllData();
        super.onDestroy();
    }




}